using System;
using System.ComponentModel.Composition;
using VRM.Integration.Servicebus.Core;
using VRM.Integration.Servicebus.Logging.CRM.Util;
using VIMT.VideoVisit.Messages;
using VIMT.VideoVisit.Processors;

namespace VIMT.VideoVisit.MessageHandler
{
	[Export(typeof(IMessageHandler))]
	[ExportMetadata("MessageType", MessageRegistry.VIMTTmpCancelAppointmentRequest)]
	/// <summary>
	/// VIMT Enterprise Component for VIMT.VirtualMeetingRoom,DeleteMeeting method, MessageHandler.
	/// Code Generated by IMS on: 4/12/2016 6:50:07 PM
	/// Version: 2016.04.08
	/// </summary>
	/// <param name=none></param>
	/// <returns>none</returns>
    public class VIMTTmpCancelAppointmentMeetingMessageHandler : RequestResponseHandler
	{
		public override IMessageBase HandleRequestResponse(object message)
		{
			try
			{
				LogMessageReceipt(message);
                var processor = new VIMTTmpCancelAppointmentProcessor();
                return processor.Execute((VIMTTmpCancelAppointmentRequest)message);
			}
			catch (Exception ex)
			{
                VIMTTmpCancelAppointmentRequest msg = (VIMTTmpCancelAppointmentRequest)message;
                LogHelper.LogError(msg.OrganizationName, msg.UserId, "VIMTTmpCancelAppointmentMeetingMessageHandler.HandleRequestResponse", ex);
                throw new Exception(string.Format("VIMTTmpCancelAppointmentMeetingMessageHandler Error: {0}", ex.Message), ex);
			}
		}
	}
}
